unit popview;

interface

uses
  WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, msMsg, Menus;

type
  TMsgViewDlg = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    FromLabel: TLabel;
    DateLabel: TLabel;
    SaveDialog1: TSaveDialog;
    ListBox1: TListBox;
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
    FMailMessage : TmsCustomMessage;
    procedure SetMailMessage(Value : TmsCustomMessage);
    procedure SaveTheAttachment(Index : Integer);
  public
    { Public declarations }
    property MailMessage : TmsCustomMessage write SetMailMessage;
  end;

var
  MsgViewDlg: TMsgViewDlg;

implementation

{$R *.DFM}

procedure TMsgViewDlg.SetMailMessage(Value : TmsCustomMessage);
var
  i : Integer;
  s : string;
  j : word;
begin
  FMailMessage:=Value;
  Memo1.Lines:=Value.Body;
  Caption:=Value.Subject;
  FromLabel.Caption:=Value.Sender.Name;
  if FromLabel.Caption='' then
    FromLabel.Caption:=Value.Sender.Address;
  DateLabel.Caption:=Value.Headers.GetFieldBody('Date');
  if Value.Attachments.Count>0 then
  begin
    ListBox1.Visible:=true;
    for i:=0 to Value.Attachments.Count-1 do
      ListBox1.Items.Add(Value.Attachments[i].FileName);
  end
  else
    ListBox1.Visible:=false;
end;

procedure TMsgViewDlg.SaveTheAttachment(Index : Integer);
var
  s : string;
begin
  s:=ListBox1.Items[ListBox1.ItemIndex];
  SaveDialog1.DefaultExt:=ExtractFileExt(s);
  SaveDialog1.FileName:=ExtractFileName(s);
  if SaveDialog1.Execute then
    FMailMessage.Attachments[ListBox1.ItemIndex].Contents.SaveToFile(SaveDialog1.FileName);
end;

procedure TMsgViewDlg.ListBox1DblClick(Sender: TObject);
begin
  SaveTheAttachment(ListBox1.ItemIndex);
end;

end.
